; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Star Complement Library"
!define PRODUCT_VERSION "2.1.1"
!define PRODUCT_PUBLISHER "Zoran Stanic, Nedeljko Stefanovic"
!define PRODUCT_WEB_SITE "http://poincare.matf.bg.ac.rs/~zstanic//scl.htm"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_RADIOBUTTONS
!insertmacro MUI_PAGE_LICENSE "..\GPLv2.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "Star Complement Library"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\SCL.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\COPYNG.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "Afrikaans"
!insertmacro MUI_LANGUAGE "Albanian"
!insertmacro MUI_LANGUAGE "Arabic"
!insertmacro MUI_LANGUAGE "Basque"
!insertmacro MUI_LANGUAGE "Belarusian"
!insertmacro MUI_LANGUAGE "Bosnian"
!insertmacro MUI_LANGUAGE "Breton"
!insertmacro MUI_LANGUAGE "Bulgarian"
!insertmacro MUI_LANGUAGE "Catalan"
!insertmacro MUI_LANGUAGE "Croatian"
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "Danish"
!insertmacro MUI_LANGUAGE "Dutch"
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Esperanto"
!insertmacro MUI_LANGUAGE "Estonian"
!insertmacro MUI_LANGUAGE "Farsi"
!insertmacro MUI_LANGUAGE "Finnish"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Galician"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Greek"
!insertmacro MUI_LANGUAGE "Hebrew"
!insertmacro MUI_LANGUAGE "Hungarian"
!insertmacro MUI_LANGUAGE "Icelandic"
!insertmacro MUI_LANGUAGE "Indonesian"
!insertmacro MUI_LANGUAGE "Irish"
!insertmacro MUI_LANGUAGE "Italian"
!insertmacro MUI_LANGUAGE "Japanese"
!insertmacro MUI_LANGUAGE "Korean"
!insertmacro MUI_LANGUAGE "Kurdish"
!insertmacro MUI_LANGUAGE "Latvian"
!insertmacro MUI_LANGUAGE "Lithuanian"
!insertmacro MUI_LANGUAGE "Luxembourgish"
!insertmacro MUI_LANGUAGE "Macedonian"
!insertmacro MUI_LANGUAGE "Malay"
!insertmacro MUI_LANGUAGE "Mongolian"
!insertmacro MUI_LANGUAGE "Norwegian"
!insertmacro MUI_LANGUAGE "NorwegianNynorsk"
!insertmacro MUI_LANGUAGE "Polish"
!insertmacro MUI_LANGUAGE "Portuguese"
!insertmacro MUI_LANGUAGE "PortugueseBR"
!insertmacro MUI_LANGUAGE "Romanian"
!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Serbian"
!insertmacro MUI_LANGUAGE "SerbianLatin"
!insertmacro MUI_LANGUAGE "SimpChinese"
!insertmacro MUI_LANGUAGE "Slovak"
!insertmacro MUI_LANGUAGE "Slovenian"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "SpanishInternational"
!insertmacro MUI_LANGUAGE "Swedish"
!insertmacro MUI_LANGUAGE "Thai"
!insertmacro MUI_LANGUAGE "TradChinese"
!insertmacro MUI_LANGUAGE "Turkish"
!insertmacro MUI_LANGUAGE "Ukrainian"
!insertmacro MUI_LANGUAGE "Uzbek"
!insertmacro MUI_LANGUAGE "Welsh"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "..\Setup.exe"
InstallDir "$PROGRAMFILES\Star Complement Library"
ShowInstDetails show
ShowUnInstDetails show

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "SCL" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "..\addendum.pdf"
  File "..\COPYNG.txt"
  File "..\GPLv2.txt"
  File "..\GPLv3.txt"
  File "..\LGPLv2-1.txt"
  File "..\LGPL_EXCEPTION.txt"
  File "..\libgcc_s_dw2-1.dll"
  File "..\mingwm10.dll"
  File "..\QtCore4.dll"
  File "..\QtGui4.dll"
  File "..\RUNTIME_EXCEPTION.txt"
  File "..\SCL.exe"
  File "..\users_guide.htm"
  SetOutPath "$INSTDIR\examples\cliques\example1"
  File "..\examples\cliques\example1\cliques.txt"
  File "..\examples\cliques\example1\egraph.txt"
  SetOutPath "$INSTDIR\examples\cliques\example2"
  File "..\examples\cliques\example2\cliques.txt"
  File "..\examples\cliques\example2\egraph.txt"
  SetOutPath "$INSTDIR\examples\cliques\example3"
  File "..\examples\cliques\example3\cliques.txt"
  File "..\examples\cliques\example3\egraph.txt"
  SetOutPath "$INSTDIR\examples\extensions\example1"
  File "..\examples\extensions\example1\egraph.txt"
  File "..\examples\extensions\example1\goodsets.txt"
  File "..\examples\extensions\example1\goodvert.txt"
  File "..\examples\extensions\example1\input.txt"
  File "..\examples\extensions\example1\maxext.txt"
  SetOutPath "$INSTDIR\examples\extensions\example2"
  File "..\examples\extensions\example2\egraph.txt"
  File "..\examples\extensions\example2\goodsets.txt"
  File "..\examples\extensions\example2\goodvert.txt"
  File "..\examples\extensions\example2\input.txt"
  File "..\examples\extensions\example2\maxext.txt"
  SetOutPath "$INSTDIR\examples\extensions\example3"
  File "..\examples\extensions\example3\egraph.txt"
  File "..\examples\extensions\example3\goodsets.txt"
  File "..\examples\extensions\example3\goodvert.txt"
  File "..\examples\extensions\example3\input.txt"
  File "..\examples\extensions\example3\maxext.txt"
  SetOutPath "$INSTDIR\examples\isomorphisms\example1"
  File "..\examples\isomorphisms\example1\classes.txt"
  File "..\examples\isomorphisms\example1\graphs.txt"
  SetOutPath "$INSTDIR\examples\isomorphisms\example2"
  File "..\examples\isomorphisms\example2\classes.txt"
  File "..\examples\isomorphisms\example2\graphs.txt"
  SetOutPath "$INSTDIR\examples\isomorphisms\example3"
  File "..\examples\isomorphisms\example3\classes.txt"
  File "..\examples\isomorphisms\example3\graphs.txt"
  SetOutPath "$INSTDIR\source"
  File "..\source\aboutwindow.cpp"
  File "..\source\aboutwindow.h"
  File "..\source\aboutwindow.ui"
  File "..\source\all_max.cpp"
  File "..\source\all_max.h"
  File "..\source\calculating.cpp"
  File "..\source\calculating.h"
  File "..\source\calculating.ui"
  File "..\source\clean.bat"
  File "..\source\cliques.cpp"
  File "..\source\cliques.h"
  File "..\source\document-open.png"
  File "..\source\extensions.cpp"
  File "..\source\extensions.h"
  File "..\source\fileview.cpp"
  File "..\source\fileview.h"
  File "..\source\fileview.ui"
  File "..\source\graph.cpp"
  File "..\source\graph.h"
  File "..\source\graph_algorithm.cpp"
  File "..\source\graph_algorithm.h"
  File "..\source\guideview.cpp"
  File "..\source\guideview.h"
  File "..\source\guideview.ui"
  File "..\source\input.cpp"
  File "..\source\input.h"
  File "..\source\install_shortcut.cpp"
  File "..\source\jacobi.cpp"
  File "..\source\jacobi.h"
  File "..\source\logo.png"
  File "..\source\main.cpp"
  File "..\source\mainicon.ico"
  File "..\source\mainicon.png"
  File "..\source\mainwindow.cpp"
  File "..\source\mainwindow.h"
  File "..\source\mainwindow.ui"
  File "..\source\README.txt"
  File "..\source\resource.qrc"
  File "..\source\resources.rc"
  File "..\source\SCL.pro"
  File "..\source\setup.nsi"
  File "..\source\string_converter.cpp"
  File "..\source\string_converter.h"
  File "..\source\window.png"
  SetOutPath "$INSTDIR\users_guide"
  File "..\users_guide\Fig1.png"
  File "..\users_guide\Fig2.png"
  File "..\users_guide\Fig3.png"
  SetOutPath "$INSTDIR\workspace\cliques"
  File "..\workspace\cliques\egraph.txt"
  SetOutPath "$INSTDIR\workspace\extensions"
  File "..\workspace\extensions\input.txt"
  SetOutPath "$INSTDIR\workspace\isomorphisms"
  File "..\workspace\isomorphisms\graphs.txt"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\SCL.lnk" "$INSTDIR\SCL.exe"
  CreateShortCut "$DESKTOP\SCL.lnk" "$INSTDIR\SCL.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\workspace\isomorphisms\graphs.txt"
  Delete "$INSTDIR\workspace\extensions\input.txt"
  Delete "$INSTDIR\workspace\cliques\egraph.txt"
  Delete "$INSTDIR\users_guide.htm"
  Delete "$INSTDIR\users_guide\Fig3.png"
  Delete "$INSTDIR\users_guide\Fig2.png"
  Delete "$INSTDIR\users_guide\Fig1.png"
  Delete "$INSTDIR\source\window.png"
  Delete "$INSTDIR\source\ui_mainwindow.h"
  Delete "$INSTDIR\source\ui_guideview.h"
  Delete "$INSTDIR\source\ui_fileview.h"
  Delete "$INSTDIR\source\ui_calculating.h"
  Delete "$INSTDIR\source\ui_aboutwindow.h"
  Delete "$INSTDIR\source\string_converter.h"
  Delete "$INSTDIR\source\string_converter.cpp"
  Delete "$INSTDIR\source\SCL.pro"
  Delete "$INSTDIR\source\resources.rc"
  Delete "$INSTDIR\source\resource.qrc"
  Delete "$INSTDIR\source\README.txt"
  Delete "$INSTDIR\source\mainwindow.ui"
  Delete "$INSTDIR\source\mainwindow.h"
  Delete "$INSTDIR\source\mainwindow.cpp"
  Delete "$INSTDIR\source\mainicon.png"
  Delete "$INSTDIR\source\mainicon.ico"
  Delete "$INSTDIR\source\main.cpp"
  Delete "$INSTDIR\source\logo.png"
  Delete "$INSTDIR\source\jacobi.h"
  Delete "$INSTDIR\source\jacobi.cpp"
  Delete "$INSTDIR\source\install_shortcut.cpp"
  Delete "$INSTDIR\source\input.h"
  Delete "$INSTDIR\source\input.cpp"
  Delete "$INSTDIR\source\guideview.ui"
  Delete "$INSTDIR\source\guideview.h"
  Delete "$INSTDIR\source\guideview.cpp"
  Delete "$INSTDIR\source\graph_algorithm.h"
  Delete "$INSTDIR\source\graph_algorithm.cpp"
  Delete "$INSTDIR\source\graph.h"
  Delete "$INSTDIR\source\graph.cpp"
  Delete "$INSTDIR\source\fileview.ui"
  Delete "$INSTDIR\source\fileview.h"
  Delete "$INSTDIR\source\fileview.cpp"
  Delete "$INSTDIR\source\extensions.h"
  Delete "$INSTDIR\source\extensions.cpp"
  Delete "$INSTDIR\source\document-open.png"
  Delete "$INSTDIR\source\cliques.h"
  Delete "$INSTDIR\source\cliques.cpp"
  Delete "$INSTDIR\source\clean.bat"
  Delete "$INSTDIR\source\calculating.ui"
  Delete "$INSTDIR\source\calculating.h"
  Delete "$INSTDIR\source\calculating.cpp"
  Delete "$INSTDIR\source\all_max.h"
  Delete "$INSTDIR\source\all_max.cpp"
  Delete "$INSTDIR\source\aboutwindow.ui"
  Delete "$INSTDIR\source\aboutwindow.h"
  Delete "$INSTDIR\source\aboutwindow.cpp"
  Delete "$INSTDIR\source\setup.nsi"
  Delete "$INSTDIR\RUNTIME_EXCEPTION.txt"
  Delete "$INSTDIR\QtGui4.dll"
  Delete "$INSTDIR\QtCore4.dll"
  Delete "$INSTDIR\mingwm10.dll"
  Delete "$INSTDIR\libgcc_s_dw2-1.dll"
  Delete "$INSTDIR\LGPL_EXCEPTION.txt"
  Delete "$INSTDIR\LGPLv2-1.txt"
  Delete "$INSTDIR\GPLv3.txt"
  Delete "$INSTDIR\GPLv2.txt"
  Delete "$INSTDIR\SCL.exe"
  Delete "$INSTDIR\examples\isomorphisms\example3\graphs.txt"
  Delete "$INSTDIR\examples\isomorphisms\example3\classes.txt"
  Delete "$INSTDIR\examples\isomorphisms\example2\graphs.txt"
  Delete "$INSTDIR\examples\isomorphisms\example2\classes.txt"
  Delete "$INSTDIR\examples\isomorphisms\example1\graphs.txt"
  Delete "$INSTDIR\examples\isomorphisms\example1\classes.txt"
  Delete "$INSTDIR\examples\extensions\example3\maxext.txt"
  Delete "$INSTDIR\examples\extensions\example3\input.txt"
  Delete "$INSTDIR\examples\extensions\example3\goodvert.txt"
  Delete "$INSTDIR\examples\extensions\example3\goodsets.txt"
  Delete "$INSTDIR\examples\extensions\example3\egraph.txt"
  Delete "$INSTDIR\examples\extensions\example2\maxext.txt"
  Delete "$INSTDIR\examples\extensions\example2\input.txt"
  Delete "$INSTDIR\examples\extensions\example2\goodvert.txt"
  Delete "$INSTDIR\examples\extensions\example2\goodsets.txt"
  Delete "$INSTDIR\examples\extensions\example2\egraph.txt"
  Delete "$INSTDIR\examples\extensions\example1\maxext.txt"
  Delete "$INSTDIR\examples\extensions\example1\input.txt"
  Delete "$INSTDIR\examples\extensions\example1\goodvert.txt"
  Delete "$INSTDIR\examples\extensions\example1\goodsets.txt"
  Delete "$INSTDIR\examples\extensions\example1\egraph.txt"
  Delete "$INSTDIR\examples\cliques\example3\egraph.txt"
  Delete "$INSTDIR\examples\cliques\example3\cliques.txt"
  Delete "$INSTDIR\examples\cliques\example2\egraph.txt"
  Delete "$INSTDIR\examples\cliques\example2\cliques.txt"
  Delete "$INSTDIR\examples\cliques\example1\egraph.txt"
  Delete "$INSTDIR\examples\cliques\example1\cliques.txt"
  Delete "$INSTDIR\COPYNG.txt"
  Delete "$INSTDIR\addendum.pdf"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\SCL.lnk"
  Delete "$DESKTOP\SCL.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR\workspace\isomorphisms"
  RMDir "$INSTDIR\workspace\extensions"
  RMDir "$INSTDIR\workspace\cliques"
  RMDir "$INSTDIR\users_guide"
  RMDir "$INSTDIR\source"
  RMDir "$INSTDIR\examples\isomorphisms\example3"
  RMDir "$INSTDIR\examples\isomorphisms\example2"
  RMDir "$INSTDIR\examples\isomorphisms\example1"
  RMDir "$INSTDIR\examples\extensions\example3"
  RMDir "$INSTDIR\examples\extensions\example2"
  RMDir "$INSTDIR\examples\extensions\example1"
  RMDir "$INSTDIR\examples\cliques\example3"
  RMDir "$INSTDIR\examples\cliques\example2"
  RMDir "$INSTDIR\examples\cliques\example1"
  RMDir "$INSTDIR\examples\isomorphisms"
  RMDir "$INSTDIR\examples\extensions"
  RMDir "$INSTDIR\examples\cliques"
  RMDir "$INSTDIR\examples"
  RMDir "$INSTDIR\workspace"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd